#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_UseUpx=y
#AutoIt3Wrapper_UPX_Parameters=--best --lzma

#include "AutoitObject.au3"
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <Memory.au3>

;===============================================================================
#interface "IPersist"
Global Const $sIID_IPersist = "{0000010c-0000-0000-C000-000000000046}"
; Definition
Global $dtagIPersist = $dtagIUnknown & _
        "GetClassID hresult(ptr*);"
; List
Global $ltagIPersist = $ltagIUnknown & _
        "GetClassID;"
;===============================================================================

;===============================================================================
#interface "IPersistStream"
Global Const $sIID_IPersistStream = "{00000109-0000-0000-C000-000000000046}"
; Definition
Global $dtagIPersistStream = $dtagIPersist & _
        "IsDirty hresult(ptr);" & _
        "Load hresult(ptr);" & _
        "Save hresult(ptr;bool);" & _
        "GetSizeMax hresult(uint64*);"
; List
Global $ltagIPersistStream = $ltagIPersist & _
        "IsDirty;" & _
        "Load;" & _
        "Save;" & _
        "GetSizeMax;"
;===============================================================================

;===============================================================================
#interface "IPersistStreamInit"
Global Const $sIID_IPersistStreamInit = "{7FD52380-4E07-101B-AE2D-08002B2EC713}"
; Definition
Global $dtagIPersistStreamInit = $dtagIPersistStream & _
        "InitNew hresult();"
; List
Global $ltagIPersistStreamInit = $ltagIPersistStream & _
        "InitNew;"
;===============================================================================

;===============================================================================
#interface "ISequentialStream"
Global Const $sIID_ISequentialStream = "{0C733A30-2A1C-11CE-ADE5-00AA0044773D}"
; Definition
Global $dtagISequentialStream = $dtagIUnknown & _
        "Read hresult(ptr;dword;dword*);" & _
        "Write hresult(ptr;dword;dword*);"
; List
Global $ltagISequentialStream = $ltagIUnknown & _
        "Read;" & _
        "Write;"
;===============================================================================

;===============================================================================
#interface "IStream"
Global Const $sIID_IStream = "{0000000C-0000-0000-C000-000000000046}"
; Definition
Global $dtagIStream = $dtagISequentialStream & _
        "Seek hresult(int64;dword;int64);" & _
        "SetSize hresult(int64);" & _
        "CopyTo hresult(ptr;int64;int64*;int64*);" & _
        "Commit hresult(dword);" & _
        "Revert none();" & _
        "LockRegion hresult(int64;int64;dword);" & _
        "UnlockRegion hresult(int64;int64;dword);" & _
        "Stat hresult(ptr;dword);" & _
        "Clone hresult(ptr*);"
; List
Global $ltagIStream = $ltagISequentialStream & _
        "Seek;" & _
        "SetSize;" & _
        "CopyTo;" & _
        "Commit;" & _
        "Revert;" & _
        "LockRegion;" & _
        "UnlockRegion;" & _
        "Stat;" & _
        "Clone;"
;===============================================================================

; Error monitoring
Global $oError = ObjEvent("AutoIt.Error", "_ErrFunc")

; Let's Start
_AutoItObject_Startup()

Global Const $sCLSID_ShockwaveFlash = "{D27CDB6E-AE6D-11CF-96B8-444553540000}"
Global Const $sIID_IShockwaveFlash = "{D27CDB6C-AE6D-11CF-96B8-444553540000}"
Global $oShockwaveFlash

; There are several available ways to create desired object:
; 1. Built-in function:
$oShockwaveFlash = ObjCreate("ShockwaveFlash.ShockwaveFlash") ;

; 2. AutoItObject's pandan:
;~ $oShockwaveFlash = _AutoItObject_ObjCreate("ShockwaveFlash.ShockwaveFlash")

; 3. The same function but this time passing CLSID:
;~ $oShockwaveFlash = _AutoItObject_ObjCreate($sCLSID_ShockwaveFlash)

; 4. _AutoItObject_ObjCreateEx. This one works from server file directly (doesn't require installed flash)
;~ $oShockwaveFlash = _AutoItObject_ObjCreateEx(@ScriptDir & "\Flash10m.ocx", $sCLSID_ShockwaveFlash, $sIID_IShockwaveFlash)

If Not IsObj($oShockwaveFlash) Then Exit -11

; GUI
Global $GUI = GUICreate("Test inline", 800, 600)
Global $idPic = GUICtrlCreatePic("", 0, 0, 150, 150)
GUICtrlSetState(-1,128)
Global $hControl = GUICtrlCreateObj($oShockwaveFlash, 0,0,800,600)
GUICtrlSetState($hControl, $GUI_DISABLE) ; Not to interact
Global $hHBitmap = Load_BMP_From_Mem(_Background(), True)
Global Const $IMAGE_BITMAP = 0
Global Const $STM_SETIMAGE = 0x0172
_WinAPI_DeleteObject(GUICtrlSendMsg($idPic, $STM_SETIMAGE, $IMAGE_BITMAP, $hHBitmap))
Global $iPos = 0
Global $vVar = _SWF_Anim()
Global $iSizeData = BinaryLen($vVar)

GUISetState()

_FlashLoadMemory($oShockwaveFlash, $vVar, $iSizeData, $iPos)

While 1
    If GUIGetMsg() = -3 Then
		_WinAPI_DeleteObject($hHBITMAP)
		Exit
	EndIf
WEnd




Func _FlashLoadMemory($oShockwaveFlash, ByRef $vData, ByRef $iSizeData, ByRef $iPos)
    #forceref $vData, $iSizeData, $iPos
    If Not IsObj($oShockwaveFlash) Then Return SetError(1, 0, False)
    _AutoItObject_IUnknownAddRef($oShockwaveFlash) ; Add reference
    Local $oFlashInterface = _AutoItObject_WrapperCreate(_AutoItObject_IDispatchToPtr($oShockwaveFlash), $dtagIUnknown)
    If Not IsObj($oFlashInterface) Then Return SetError(2, 0, False)
    Local $oFlashMemoryStream = _AutoItObject_ObjectFromDtag("_FlashMemoryStream_", $dtagIStream)
    Local $tIID_IPersistStreamInit = _AutoItObject_CLSIDFromString($sIID_IPersistStreamInit)
    Local $aCall = $oFlashInterface.QueryInterface(Number(DllStructGetPtr($tIID_IPersistStreamInit)), 0)
    Local $pPersistStreamInit = $aCall[2]
    Local $oPersistStreamInit = _AutoItObject_WrapperCreate($pPersistStreamInit, $dtagIPersistStreamInit)
    $oPersistStreamInit.InitNew()
    $oPersistStreamInit.Load(Number($oFlashMemoryStream.__ptr__))
    Return True
EndFunc   ;==>_FlashLoadMemory

; IStream definition, custom implementation:
Func _FlashMemoryStream_QueryInterface($pSelf, $pRIID, $pObj)
    #forceref $pSelf, $pRIID, $pObj
    Return 0x80004002 ; E_NOINTERFACE
EndFunc   ;==>_FlashMemoryStream_QueryInterface
Func _FlashMemoryStream_AddRef($pSelf)
    #forceref $pSelf
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_AddRef
Func _FlashMemoryStream_Release($pSelf)
    #forceref $pSelf
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Release
Func _FlashMemoryStream_Read($pSelf, $pBuffer, $iCb, $pRead)
    #forceref $pSelf
    If $iPos = 0 And $iCb = 4 Then
        DllStructSetData(DllStructCreate("char[4]", $pBuffer), 1, "fUfU")
        $iPos += 4
    ElseIf $iPos = 4 And $iCb = 4 Then
        DllStructSetData(DllStructCreate("dword", $pBuffer), 1, $iSizeData)
        $iSizeData += 8
        $iPos += 4
    Else
        If $iPos + $iCb > $iSizeData Then $iCb = $iSizeData - $iPos
        If $iCb = 0 Then Return 1 ; S_FALSE
        DllStructSetData(DllStructCreate("byte[" & $iCb & "]", $pBuffer), 1, BinaryMid($vVar, 1 + $iPos - 8, $iCb))
        If $pRead Then DllStructSetData(DllStructCreate("dword", $pRead), 1, $iCb)
        $iPos += $iCb
    EndIf
    Return 0 ; S_OK
EndFunc   ;==>_FlashMemoryStream_Read
Func _FlashMemoryStream_Write($pSelf, $pBuffer, $iCb, $iWritten)
    #forceref $pSelf, $pBuffer, $iCb, $iWritten
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Write
Func _FlashMemoryStream_Seek($pSelf, $iMove, $iOrigin, $iNewPos)
    #forceref $pSelf, $iMove, $iOrigin, $iNewPos
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Seek
Func _FlashMemoryStream_SetSize($pSelf, $iNewSize)
    #forceref $pSelf, $iNewSize
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_SetSize
Func _FlashMemoryStream_CopyTo($pSelf, $pStream, $iCb, $pRead, $pWritten)
    #forceref $pSelf, $pStream, $iCb, $pRead, $pWritten
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_CopyTo
Func _FlashMemoryStream_Commit($pSelf, $iCommitFlags)
    #forceref $pSelf, $iCommitFlags
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Commit
Func _FlashMemoryStream_Revert($pSelf)
    #forceref $pSelf
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Revert
Func _FlashMemoryStream_LockRegion($pSelf, $iOffset, $iCb, $iLockSize)
    #forceref $pSelf, $iOffset, $iCb, $iLockSize
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_LockRegion
Func _FlashMemoryStream_UnlockRegion($pSelf, $iOffset, $iCb, $iLockSize)
    #forceref $pSelf, $iOffset, $iCb, $iLockSize
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_UnlockRegion
Func _FlashMemoryStream_Stat($pSelf, $pStatstg, $iFlag)
    #forceref $pSelf, $pStatstg, $iFlag
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Stat
Func _FlashMemoryStream_Clone($pSelf, $pStream)
    #forceref $pSelf, $pStream
    Return 0x80004001 ; E_NOTIMPL
EndFunc   ;==>_FlashMemoryStream_Clone


; On Error
Func _ErrFunc()
    ConsoleWrite("COM Error, ScriptLine(" & $oError.scriptline & ") : Number 0x" & Hex($oError.number, 8) & " - " & $oError.windescription & @CRLF)
EndFunc   ;==>_ErrFunc

;Code was generated by: File to Base64 String Code Generator

Func _SWF_Anim()
	Local $SWF_Anim
	$SWF_Anim &= 'Q1dTCKgNAAB4nKWWS2wbRRjHPzuJncRx3qGtSIRxVB5qnX3Yjh+kbhI/0hbZqdJE5ULbjXcdb/E+tLt58RBRDwikigOHCIQ4tohWQoIDAgRq4YBAAoTErReERCUuvcKtYWa9M7uJk6iApczufN/3+8833zc7ig5dVwCUK9Dth8JAPwC8PtTeATBliLXsQqEU2VAaqplFs1PRumXpWYZZX1+fWI9PaMYKw2UyGYblGZ6PoYiYualawkZMNcejuYitUJDMqiHrlqypETwXlrVV61Q06shuKDqVVc0JQdSWpYmqpjAbgs5wEyyDdVBQNm9IgqUZi5rWyM3gqEipIZj1yHlDq0mmieSFRiR/ITnF7I328FIB/eV4luNibCrGphc5Lsux2UT6BJvMxlkP24xsomXJEkTBEnbBcW6Ry2RZNsvzXnhXrINrolzbfCTYjYxMMXuq98j1LJcPr6iiMCTatBak2uHR5uKmLjELkqmtGlUJhY87HSmXs2dV0xLUqnS2kEOGCVkWs5OJZDLOlQqp9OxsEe02zcZLxUSiwKdKqcTMbNre6G6UqBW06qoiqZajJv4LNQ9K1OYNeUVGZ2If1QSXz/PpfIKfnMnYqlw8neZni8V4plQolPJEdR8JmqtkyGuSWDI0xe6CLhimhCt1KkpKhctk1zcrt5Ypk2LTqSLKoHjQxlpQoia2bijNpoqzaS7DFw/aUAtK1LT/U6YDJSK0MW6d/vORFqv0hOqrRsO+dsQqIzUkvJqJTiln3xJiNVvTDEWwcoKuN+SqgAWZjZhZ16ovrQtrUqyGb4wpxg3cNyXGufhyEcj70XV4uu1+G8Cbt2AEZLhsaJoF6qqyjDoOaFjWrM2mdaIhqxJc3gRDUMW6JK/ULSgLVt2eawoowoZjtTRdl4xNWBF0EKVqzRCqeG0sa1qSboIiq05oU7kJwIxhCJsOLRqaDppaVC3JKBmCIsFVkFXZsvN6P+y+Ayz5toPQCUEfeh/b9qPXUTz67NFf2e5ouubODH7gh2d82No26sS1Q2c7es7Z847KPH4EiDMEAXB+nUHb2LmAx67RHjuwe9RdjShWvAqVEH6GRkN2eI8nPOANb2YaroTnPfkEASXdP+M4A5WW+N7K3DiO7/PEb50+LJEmF/JOeishW8TOixRq7D0/fPZwO4x25Ragf3oMWwItlu4WS89uC2qOP9hnNwe9dgWvk9dep2UhlFTg95et068MfzxnTwc8UxQYDnaT3jbTHny/A8uftDs/5HZ+6JDO70CzukMHVXdotDLu4tTmLdbKIFZKHazUiyS8x6ZpHV44gkq6Aq3qh67XQ0yh+Waj7QW7nEY7U/vcusyAcyqGsLi3ob89nIc78Cua+kB7J/fNxWmA7sGvLyzfvAt+aIedHeQa/OqjT29+q255LF9ckMrX/z735R7LA4+l//PxjlKPbUG/HfTzWsLv7rV01fZa2rl9LDCPLNH7M1e7a3+t3XgRqBWmR+5cuX1j7Vb82p8Pbn/oZ2GnC/9j50dbeyMQ8OECod3BncAIGp/yIccPyHvpp95qfRrfYhzsDDPI1QZL37398O75pXtvbeG6+IbRdzD4ydjAL3gxvBM8+o5frPv+KNx1Vmknq7SRVY7gVdqQ4/trL0xDuKONnW5eYhxJoYOmcNRJgSdckHJ9lOMJ10W5kw4XJ1yIcscoFydcmHJRh0sQro9y45RLEG6AcpMOlyTcEOVilEsSboRy0w43SbgjlEtRbpJwxwj3c5m914+5FOEet7lFxM1QLkW4MbreOWe9NOGeoNzzlEsT7knKLTpchnDjlFuiHHY+hp3HKXeJHCEW+Y5i39MUvOw2niXks5SsE5Ij5AlKyi7JETJGSYOQPCEZSpouyROSo+SrhIwTMk7J11wyTsgk7Ufe6QeXIGSKkL35rR/7HTJByAwlzxAyScjnKHnGJZPo48Gfzz8gunpA'

	Return Binary(_Base64Decode($SWF_Anim))
EndFunc   ;==>_SWF_Anim

Func _Background()
	Local $Bg
	$Bg &= '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'
	$Bg &= 'AC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8APxwvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwA/HC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAD8cLwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAC8APxwvAC8ALwADLwAjAEixyD/MSGYhAAD/Qn8B/78AvwD/cL8AvwC/AL8AXwD/XwBfAF8AXwB/OF8AXwBfAP9fAF8AXwBfAF8AXwBfAF8A/18AfzhfAF8AXwBfAF8AXwD/XwBfAF8AXwAvAC8ALwAvAP8vAD8cLwAvAC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8APxwvAC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwA/HC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAD8cbwEvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8APxw/AS8AHy8ALwAvAC8AIwBIscjMSD9KIQAA/0J/Af+/AL8A/3C/AL8AvwC/AF8A/18AXwBfAF8AfzhfAF8AXwD/XwBfAF8AXwBfAF8AXwBfAP9fAH84XwBfAF8AXwBfAF8A/18AXwBfAF8AXwAvAC8ALwD/PxwvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwA/HC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAD8cbwEvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAC8APxw/AS8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAD8cLwAvAB8vAC8ALwAvAC8ATLHISD/MLiEAAP9CfwH/vwC/AP9wvwC/AL8AvwBfAP9fAF8AXwBfAH84XwBfAF8A/18AXwBfAF8AXwBfAF8AXwD/XwB/OF8AXwBfAF8AXwBfAP9fAF8AXwBfAF8ALwAvAC8A/z8cLwAvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8APxwvAC8ALwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwA/HG8BLwAvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAD8cPwEvAC8ALwD/LwAvAC8ALwAvAC8ALwAvAP8vAC8ALwAvAC8ALwAvAC8A/y8ALwAvAC8ALwA/HC8ALwB/LwAvAC8ALwAvAC8AJwBbscg/zEgSIQAA/0J/Af+/AL8A/3C/AL8AvwC/AL8Aj18AXwBfAGs43U5EXwD/XwBfAF8AXwBfAF8AXwBfAB9fAF8AXwBfAEIAAABm/CQgXwBfAF8AXwBfAF8A/18AXwBfAF8AXwBfAC8ALwD9IAAADwAPAA8ADwAPAA8A/w8ADwAPAA8ADwAPAA8ADwD/DwAPAA8ADwAPAA8ADwAPAP8PAA8ADwAPAA8ADwAPAA8A/w8ADwAPAA8ADwAPAA8ADwD/DwAPAA8ADwAPAA8ADwAPAP8PAA8ADwAPAA8ADwAPAA8A/w8ADwAPAA8ADwAPAA8ADwD/DwAPAA8ADwAPAA8ADwAPAP8PAA8ADwAPAA8ADwAPAA8A/w8ADwAP'
	$Bg &= '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'
	$Bg &= 'AC8ALwAvAA8vAC8ALwA5HAAA'
	$Bg = _Base64Decode($Bg)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Bg) & ']')
	DllStructSetData($tSource, 1, $Bg)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress)
	$tSource = 0
	Return Binary(DllStructGetData($tDecompress, 1))
EndFunc   ;==>_Base64String

Func _Base64Decode($input_string)
	Local $struct = DllStructCreate("int")
	Local $a_Call = DllCall("Crypt32.dll", "int", "CryptStringToBinary", "str", $input_string, "int", 0, "int", 1, "ptr", 0, "ptr", DllStructGetPtr($struct, 1), "ptr", 0, "ptr", 0)
	If @error Or Not $a_Call[0] Then Return SetError(1, 0, "")
	Local $a = DllStructCreate("byte[" & DllStructGetData($struct, 1) & "]")
	$a_Call = DllCall("Crypt32.dll", "int", "CryptStringToBinary", "str", $input_string, "int", 0, "int", 1, "ptr", DllStructGetPtr($a), "ptr", DllStructGetPtr($struct, 1), "ptr", 0, "ptr", 0)
	If @error Or Not $a_Call[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($a, 1)
EndFunc   ;==>_Base64Decode

Func _WinAPI_LZNTDecompress(ByRef $tInput, ByRef $tOutput, $iBufferSize = 0x800000)
	Local $tBuffer, $Ret
	$tOutput = 0
	$tBuffer = DllStructCreate('byte[' & $iBufferSize & ']')
	If @error Then Return SetError(1, 0, 0)
	$Ret = DllCall('ntdll.dll', 'uint', 'RtlDecompressBuffer', 'ushort', 0x0002, 'ptr', DllStructGetPtr($tBuffer), 'ulong', $iBufferSize, 'ptr', DllStructGetPtr($tInput), 'ulong', DllStructGetSize($tInput), 'ulong*', 0)
	If @error Then Return SetError(2, 0, 0)
	If $Ret[0] Then Return SetError(3, $Ret[0], 0)
	$tOutput = DllStructCreate('byte[' & $Ret[6] & ']')
	If Not _WinAPI_MoveMemory(DllStructGetPtr($tOutput), DllStructGetPtr($tBuffer), $Ret[6]) Then
		$tOutput = 0
		Return SetError(4, 0, 0)
	EndIf
	Return $Ret[6]
EndFunc   ;==>_WinAPI_LZNTDecompress

Func _WinAPI_MoveMemory($pDestination, $pSource, $iLenght)
	DllCall('ntdll.dll', 'none', 'RtlMoveMemory', 'ptr', $pDestination, 'ptr', $pSource, 'ulong_ptr', $iLenght)
	If @error Then Return SetError(5, 0, 0)
	Return 1
EndFunc   ;==>_WinAPI_MoveMemory

;======================================================================================
; Function Name:		Load_BMP_From_Mem
; Description:			Loads an image which is saved as a binary string and converts it to a bitmap or hbitmap
;
; Parameters:    		$bImage:		the binary string which contains any valid image which is supported by GDI+
; Optional:  				$hHBITMAP:		if false a bitmap will be created, if true a hbitmap will be created
;
; Remark:					hbitmap format is used generally for GUI internal images, $bitmap is more a GDI+ image format
;
; Requirement(s):		GDIPlus.au3, Memory.au3
; Return Value(s):	Success: handle to bitmap or hbitmap, Error: 0
; Error codes:			1: $bImage is not a binary string
;								2: unable to create stream on HGlobal
;								3: unable to create bitmap from stream
;
; Author(s):				UEZ
; Additional Code:	thanks to progandy for the MemGlobalAlloc and tVARIANT lines
; Version:					v0.96 Build 2011-08-14 Beta
;=======================================================================================
Func Load_BMP_From_Mem($bImage, $hHBITMAP = False)
	If Not IsBinary($bImage) Then Return SetError(1, 0, 0)
	Local $declared = True
	If Not $ghGDIPDll Then
		_GDIPlus_Startup()
		$declared = False
	EndIf
	Local $aResult
	Local Const $memBitmap = Binary($bImage) ;load image  saved in variable (memory) and convert it to binary
    Local Const $len = BinaryLen($memBitmap) ;get length of image
    Local Const $hData = _MemGlobalAlloc($len, $GMEM_MOVEABLE) ;allocates movable memory  ($GMEM_MOVEABLE = 0x0002)
    Local Const $pData = _MemGlobalLock($hData) ;translate the handle into a pointer
    Local $tMem = DllStructCreate("byte[" & $len & "]", $pData) ;create struct
    DllStructSetData($tMem, 1, $memBitmap) ;fill struct with image data
    _MemGlobalUnlock($hData) ;decrements the lock count  associated with a memory object that was allocated with GMEM_MOVEABLE
    $aResult = DllCall("ole32.dll", "int", "CreateStreamOnHGlobal", "handle", $pData, "int", True, "ptr*", 0) ;Creates a stream object that uses an HGLOBAL memory handle to store the stream contents
	If @error Then SetError(2, 0, 0)
	Local Const $hStream = $aResult[3]
    $aResult = DllCall($ghGDIPDll, "uint", "GdipCreateBitmapFromStream", "ptr", $hStream, "int*", 0) ;Creates a Bitmap object based on an IStream COM interface
	If @error Then SetError(3, 0, 0)
	Local Const $hBitmap = $aResult[2]
    Local $tVARIANT = DllStructCreate("word vt;word r1;word r2;word r3;ptr data; ptr")
    DllCall("oleaut32.dll", "long", "DispCallFunc", "ptr", $hStream, "dword", 8 + 8 * @AutoItX64, _
										   "dword", 4, "dword", 23, "dword", 0, "ptr", 0, "ptr", 0, "ptr", DllStructGetPtr($tVARIANT)) ;release memory from $hStream to avoid memory leak
    $tMem = 0
	$tVARIANT = 0
    If $hHBITMAP Then
        Local Const $hHBmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBitmap)
        _GDIPlus_BitmapDispose($hBitmap)
		If Not $declared Then _GDIPlus_Shutdown()
        Return $hHBmp
    EndIf
	If Not $declared Then _GDIPlus_Shutdown()
    Return $hBitmap
EndFunc   ;==>Load_BMP_From_Mem